//
//  CQAdFeedAdDemoViewController.m
//  CQAdDemo
//
//  Created by splendourbell on 2021/10/13.
//

#import "CQAdFeedAdDemoViewController.h"
#import <CQAdSDK/CQAdSDK.h>

@interface CQAdFeedAdDemoViewController ()<CQAdExpressFeedAdDelegate,UITableViewDelegate, UITableViewDataSource>

@property (nonatomic) CQAdExpressFeedAd* expressFeedAd;

@property (nonatomic, strong) UITableView* tableView;

@property (nonatomic, strong) NSMutableArray* dataArray;

@end

@implementation CQAdFeedAdDemoViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self setupViews];
    
    [self loadExpressFeedAd];
}

- (void)setupViews
{
    self.view.backgroundColor = UIColor.grayColor;
    
    self.dataArray = NSMutableArray.new;
    for(NSInteger i=0; i<15; i++)
    {
        [self.dataArray addObject:[NSString stringWithFormat:@"data row %@", @(i)]];
    }
        
    self.tableView = [[UITableView alloc] initWithFrame:self.view.bounds style:UITableViewStylePlain];
    [self.view addSubview:self.tableView];
    
    self.tableView.delegate = self;
    self.tableView.dataSource = self;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return self.dataArray.count;
}

- (UITableViewCell*)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    UITableViewCell* cell = nil;
    id data = self.dataArray[indexPath.row];
    if([data isKindOfClass:CQAdExpressFeedAdObject.class])
    {
        CQAdExpressFeedAdObject* adObject = (CQAdExpressFeedAdObject*)data;
        
        cell = [tableView dequeueReusableCellWithIdentifier:@"adRowIdentifier"];
        if(!cell)
        {
            cell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:@"adRowIdentifier"];
        }
        
        [[cell.contentView viewWithTag:100] removeFromSuperview];
        adObject.view.tag = 100;
        [cell.contentView addSubview:adObject.view];
    }
    else
    {
        cell = [tableView dequeueReusableCellWithIdentifier:@"normalDataRowIdentifier"];
        if(!cell)
        {
            cell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:@"normalDataRowIdentifier"];
        }
        cell.contentView.backgroundColor = (indexPath.row % 2) ? UIColor.redColor : UIColor.grayColor;
    }
    return cell;
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    id data = self.dataArray[indexPath.row];
    if([data isKindOfClass:CQAdExpressFeedAdObject.class])
    {
        CQAdExpressFeedAdObject* adObject = (CQAdExpressFeedAdObject*)data;
        return adObject.view.frame.size.height;
    }
    return 50;
}

//======================================================================
//百度广告要求上报 展示 事件。（如果明确后台不配置百度信息流广告，可以不调用此方法

- (void)scrollViewDidEndDragging:(UIScrollView *)scrollView willDecelerate:(BOOL)decelerate 
{
    if (!decelerate) 
    {
        [self checkAdViewImpression];
    }
}

- (void)scrollViewDidEndDecelerating:(UIScrollView *)scrollView
{
    [self checkAdViewImpression];
}

- (void)tableView:(UITableView *)tableView willDisplayCell:(UITableViewCell *)cell forRowAtIndexPath:(NSIndexPath *)indexPath 
{
    [self trackImpressionRow:indexPath.row];
}

- (void)checkAdViewImpression
{
    NSArray *visiblePath = [self.tableView indexPathsForVisibleRows];
    for (NSIndexPath *visible in visiblePath) 
    {
        [self trackImpressionRow:visible.row];
    }
}

- (void)trackImpressionRow:(NSInteger)rowIndex
{
    if(rowIndex >= 0 && rowIndex < self.dataArray.count)
    {
        id data = [self.dataArray objectAtIndex:rowIndex];
        if([data isKindOfClass:CQAdExpressFeedAdObject.class])
        {
            CQAdExpressFeedAdObject* adObject = (CQAdExpressFeedAdObject*)data;
            [adObject trackImpression];
        }
    }
}

//======================================================================

- (void)loadExpressFeedAd
{
    CGFloat width = UIScreen.mainScreen.bounds.size.width;
    
    self.expressFeedAd = [[CQAdExpressFeedAd alloc] initWithPlacementId:@"2000015485" width:width viewController:self];
    self.expressFeedAd.delegate = self;
    [self.expressFeedAd loadAds:3];
}

#pragma mark ExpressFeedAd delegate

- (void)cqAdExpressFeedAdLoadSuccess:(CQAdExpressFeedAd *)expressFeedAd adObjects:(NSArray<CQAdExpressFeedAdObject*> *)adObjects
{
    NSLog(@"CQAdExpressFeedAd:cqAdExpressFeedAdLoadSuccess");

    
    [adObjects enumerateObjectsUsingBlock:^(CQAdExpressFeedAdObject* _Nonnull obj, NSUInteger idx, BOOL * _Nonnull stop) {
        [obj render];
    }];
}

- (void)cqAdExpressFeedAdLoadFailed:(CQAdExpressFeedAd *)expressFeedAd error:(NSError *)error
{
    NSLog(@"CQAdExpressFeedAd:cqAdExpressFeedAdLoadFailed");
    

    
}

- (void)cqAdExpressFeedAdViewRenderSuccess:(CQAdExpressFeedAd *)expressFeedAd adObject:(CQAdExpressFeedAdObject *)adObject
{
    NSLog(@"CQAdExpressFeedAd:cqAdExpressFeedAdViewRenderSuccess");
    

    
    if(self.dataArray.count > 0)
    {
        [self.dataArray insertObject:adObject atIndex:(arc4random() % self.dataArray.count)];
    } 
    else 
    {
        [self.dataArray addObject:adObject];
    }
    [self.tableView reloadData];
}

- (void)cqAdExpressFeedAdViewRenderFail:(CQAdExpressFeedAd *)expressFeedAd adObject:(CQAdExpressFeedAdObject *)adObject
{
    NSLog(@"CQAdExpressFeedAd:cqAdExpressFeedAdViewRenderFail");
    

    
}

- (void)cqAdExpressFeedAdViewExposure:(CQAdExpressFeedAd *)expressFeedAd adObject:(CQAdExpressFeedAdObject*)adObject
{
    NSLog(@"CQAdExpressFeedAd:cqAdExpressFeedAdViewExposure");
    

    
}

- (void)cqAdExpressFeedAdDidClick:(CQAdExpressFeedAd *)expressFeedAd adObject:(CQAdExpressFeedAdObject *)adObject
{
    NSLog(@"CQAdExpressFeedAd:cqAdExpressFeedAdDidClick");
    

    
}

- (void)cqAdExpressFeedAdViewDidRemoved:(CQAdExpressFeedAd *)expressFeedAd adObject:(CQAdExpressFeedAdObject *)adObject
{
    NSLog(@"CQAdExpressFeedAd:cqAdExpressFeedAdViewDidRemoved");
    [self.dataArray removeObject:adObject];
    [self.tableView reloadData];
    

    
}



@end
